"""##################################### TERMS OF USE ###########################################
# The following code is provided for demonstration purpose only, and should not              #
# be used without independent verification. Recorded Future makes no representations         #
# or warranties, express, implied, statutory, or otherwise, regarding any aspect of          #
# this code or of the information it may retrieve, and provides it both strictly “as-is”     #
# and without assuming responsibility for any information it may retrieve. Recorded Future   #
# shall not be liable for, and you assume all risk of using, the foregoing. By using this    #
# code, Customer represents that it is solely responsible for having all necessary licenses, #
# permissions, rights, and/or consents to connect to third party APIs, and that it is solely #
# responsible for having all necessary licenses, permissions, rights, and/or consents to     #
# any data accessed from any third party API.                                                #
##############################################################################################
"""

import re

from .constants import IPV6_REGEX
from .errors import CategoryParseError


def get_category(value):
    """Return the category of value (ip, domain...).

    value    - the value used in the patterns.

    >>> get_category('auto', '10.20.30.40')
    'ip'

    >>> get_category('auto', 'www.example.com')
    'domain'

    >>> get_category('auto', 'http://www.example.com/index.html')
    'url'

    >>> get_category('ip', 'apa.bepa.cepa')
    'ip'
    """
    if re.match(r'^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$', value) is not None:
        return 'ip'

    if re.match(IPV6_REGEX, value) is not None:
        return 'ip'

    if re.match(r'^[a-z-.+]+:.+$', value) is not None:
        return 'url'

    if re.match(r'^\S+(\.\S+){1,}$', value) is not None:
        return 'domain'

    if re.match(r'(?i)^[0-9a-f]+$', value) is not None:
        return 'hash'

    if re.match(r'CVE-\d{4}-\d{4,7}', value) is not None:
        return 'vulnerability'

    raise CategoryParseError('Failed to automatically detect category for %s' % value)
