## **Overview**

Recorded Future Collective Insights is a new type of analytic, providing clients a complete view of what threats matters to an organization. Collective Insights aggregates detections across client integrations, confirming indicators related to malicious behavior or high-risk activity. This helps TI and SecOps users better prevent and protect client networks by prioritizing their actions based on which detections and TTPs are most common across their networks. This article will walk through how to setup Collective Insights for Exabeam using the [Recorded Future collective insights API](https://support.recordedfuture.com/hc/en-us/articles/15847735339923-Collective-Insights-API).

The following script will ingest events from Exabeam matching the filter `is_ioc`. The script runs an intial search based on the 'lookback' `-L` command line argument specifying the time in hours to search the Exabeam API (or 1 hour by default). Once the script executes for the first time a timestamp is saved to file that is then referenced in future script executions depending on the events returned. If events are returned then the timestamp saved is the timestamp of the latest Exabeam event. Otherwise the timestamp saved will be the script execution time. Following executions add one millisecond to this reference timestamp when searching the next round of documents to send to Collective Insights.
- To overwrite the saved timestamp with the command line argument lookback you must first delete the file at `config/latest_timestamp.txt` and then run the python script.

Fields Collected from each incident by Recorded Future:

- `id` - Event ID
- `time` - Timestamp of the detected event
- `ioc_fields` - Exabeam event field listing the indicators found in the event. Recorded Future only collects fields matching the types in `ip, domain, hash, url, vulnerability`
- `mitre_labels` - Specific MITRE ATT&CK techniques and tactics used in a particular security incident
- `malware_family` - Specific family or group of malware associated with an event or alert

## **Prerequisites**

The following items be installed/gathered before the setup of the integration script

1. Python v3.10 or greater must be installed
2. Client must have Exabeam Search API access
3. Client must be able to provide an environment to run the script locally with access to the internet.
   - Server/Workstation for script to run on schedule
   - Internet Access to Recorded Future API & Exabeam API
   - Recommend whitelisting [api.recordedfuture.com](http://api.recordedfuture.com/)
4. Client must have Recorded Future API Token with access to Collective Insights API
   - This can be provided by your IntServ Consultant or PS Engineer
5. Client must have the following from Exabeam:

   - Instance Region
   - API Client ID
   - API Client Secret

# **Installation**

The Exabeam Collective Insights python script can be provided via the assigned Professional Services engineer.

Once package has been provided and downloaded to the machine where installation will be ran the following steps can be taken to configure and run the script for the first time.

You may opt to store client credentials/secrets as environment variables instead of passing them as parameters to the script. If you choose to do so, you will need to set the following environment variables:

- RF_API_KEY
- EXABEAM_CLIENT_ID
- EXABEAM_CLIENT_SECRET
- REGION

Set-up Instructions
1. Setup a new virtual environment to install dependencies and run the script from:`python3 -m venv venv`
2. Activate new virtual environment:`source venv/bin/activate`
3. Install dependencies from requirements.txt: `pip3 install -r requirements.txt`
4. Run python script to confirm successful: `python3 run_exabeam_ci.py -h`
   - `usage: run_exabeam_ci.py [-h] [-k RF_API_KEY] [-c CLIENT_ID] [-s CLIENT_SECRET] [-r {us-west,us-east,canada,europe,singapore,japan,australia}] [-L LOOKBACK] [--debug] [-l {DEBUG,INFO,WARNING,ERROR,CRITICAL}]`
5. Setup script to run on schedule daily to ingest events and send to collective insights:
   - Example cron schedule to run at 00:15 every night: `15 0 * * * <FILE_DIR>/venv/bin/python3 <FILE_DIR>/run_exabeam_ci.py -k RF_API_KEY`

# **Troubleshooting**

The below section is for providing assistance with troubleshooting when having issues running the script.

- Script is failing due to modules not installed.
  - Confirm the requirements.txt was installed properly with pip3
  - Confirm the virtual environment where the python packages are installed is activated
- Not authorized to collect events from Exabeam
  - Confirm the Exabeam Region, Client ID, and Client Secret are accurate for the input parameters
- Not authorized to submit to Recorded Future Collective Insights API
  - Confirm that the Recorded Future API token has the correct Collective Insights API permissions activated
- Why am I ingesting more events from Exabeam than are being submitted to Collective Insights?
  - Collective Insights has filtering for unique indicators when submitting via the api.
