"""##################################### TERMS OF USE ###########################################
# The following code is provided for demonstration purpose only, and should not              #
# be used without independent verification. Recorded Future makes no representations         #
# or warranties, express, implied, statutory, or otherwise, regarding any aspect of          #
# this code or of the information it may retrieve, and provides it both strictly “as-is”     #
# and without assuming responsibility for any information it may retrieve. Recorded Future   #
# shall not be liable for, and you assume all risk of using, the foregoing. By using this    #
# code, Customer represents that it is solely responsible for having all necessary licenses, #
# permissions, rights, and/or consents to connect to third party APIs, and that it is solely #
# responsible for having all necessary licenses, permissions, rights, and/or consents to     #
# any data accessed from any third party API.                                                #
##############################################################################################
"""

APP_ID = 'exabeam-ci-partner'
COLLECTIVE_INSIGHTS_API_URL = 'https://api.recordedfuture.com/collective-insights/detections'
COLLECTIVE_INSIGHTS_INCIDENT_NAME = 'Exabeam Threat Detection'
COLLECTIVE_INSIGHTS_INCIDENT_TYPE = 'exabeam-threat-detection'
EXABEAM_SEARCH_API = 'search/v2/events'
EXABEAM_AUTH_API = 'auth/v1/token'
LOOKBACK = 1
MAX_RESULTS = 1000
MITRE_REGEX = 'T[A]?[0-9][.0-9]+'
TIMESTAMP_FORMAT = '%Y-%m-%dT%H:%M:%S.%fZ'

API_BASE_URL_MAP = {
    'us-west': 'https://api.us-west.exabeam.cloud/',
    'us-east': 'https://api.us-east.exabeam.cloud/',
    'canada': '	https://api.ca.exabeam.cloud/',
    'europe': 'https://api.eu.exabeam.cloud/',
    'singapore': 'https://api.sg.exabeam.cloud/',
    'japan': 'https://api.jp.exabeam.cloud/',
    'australia': 'https://api.au.exabeam.cloud/',
}

EXABEAM_EVENT_FIELDS = [
    'id',
    'time',
    'ioc_fields',
]

IPV6_REGEX = (
    r'^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]'
    r'{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|(['
    r'0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA'
    r'-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:'
    r'((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4})'
    r'{0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){'
    r'0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,'
    r'4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9])'
    r'{0,1}[0-9]))$'
)
