## **Overview**

Recorded Future Collective Insights is a new type of analytic, providing clients a complete view of what threats matters to an organization. Collective Insights aggregates detections across client integrations, confirming indicators related to malicious behavior or high-risk activity. This helps TI and SecOps users better prevent and protect client networks by prioritizing their actions based on which detections and TTPs are most common across their networks. This article will walk through how to setup Collective Insights for Elasticsearch using the [Recorded Future collective insights API](https://support.recordedfuture.com/hc/en-us/articles/15847735339923-Collective-Insights-API).

The following script will ingest documents from the Elasticsearch alerts index generated from Indicator Detection Rules. The script runs an intial search based on the 'lookback' `-L` command line argument specifying the time in hours to search the Elasticsearch alerts index (or 1 hour by default). Once the script executes for the first time a timestamp is saved to file that is then referenced in future script executions depending on the alerts returned. If alerts are returned then the timestamp saved is the timestamp of the latest Elasticsearch alert. Otherwise the timestamp saved will be the script execution time. Following executions add one millisecond to this reference timestamp when searching the next round of documents to send to Collective Insights.
- To overwrite the saved timestamp with the command line argument lookback you must first delete the file at `config/latest_timestamp.txt` and then run the python script.

By Default the Elasticsearch instance major version number determines which Alert index is queried by the script:
- v8.0.0 or later: `.alerts-security.alerts-*`
- Before v8.0.0: `.siem-signals-*`

Users can override the default alerts index if needed within `config/settings.ini`.

Fields Collected from each incident by Recorded Future:

- `_id` - Unique Elasticsearch document ID
- `@timestamp` - Alert Timestamp in ECS format. Can be overwritten for custom field.
- `hostname` - Elasticsearch document hostname in ECS format. Can be overwritten for custom field.
- `threat.enrichments.matched.atomic` - Indicator value written back to Recorded Future. Recorded Future only collects fields matching the types in `ip, domain, hash, and url`.
- `kibana.alert.rule.name` - Name of the Indicator Match Rule that triggered the alert.
- `threat.tactic.id` - Specific MITRE ATT&CK techniques and tactics used in a particular security incident.

## **Prerequisites**

The following items be installed/gathered before the setup of the integration script

1. Python v3.8.10 or greater must be installed
2. Client must have access to the Elasticsearch API
3. Client must be able to provide an environment to run the script locally with access to the internet.
   - Server/Workstation for script to run on schedule
   - Internet Access to Recorded Future API & Elasticsearch API
   - Recommend whitelisting [api.recordedfuture.com](http://api.recordedfuture.com/)
4. Client must have Recorded Future API Token with access to Collective Insights API
   - This can be provided by your IntServ Consultant or PS Engineer
5. Client must have the following from Elasticsearch:

   - Elasticsearch Host: Cloud ID, Hostname(s)
   - Authentication Method, one of:
        - API Token ID & Token Secret (API Token Authentication)
        - Username & Password (Basic Authentication)
        - CA, Client Cert, and Client Key files (Certificate Authentication)
   - `read` index privilege to read data and search data in the alerts index

# **Installation**

The Elasticsearch Collective Insights python script can be provided via the assigned Professional Services engineer.

Once package has been provided and downloaded to the machine where installation will be ran the following steps can be taken to configure and run the script for the first time.

Before running the script, inspect `config/settings.ini` and adjust the parameters as needed. You may opt to store client credentials/secrets as environment variables instead of passing them as parameters to the script. If you choose to do so, you will need to set the following environment variables:

- Collective Insights API: RF_API_KEY
- Elasticsearch User Authentication:
   - ELASTIC_USER | ELASTIC_PASSWORD

Set-up Instructions
1. Setup a new virtual environment to install dependencies and run the script from:`python3 -m venv venv`
2. Activate new virtual environment:`source venv/bin/activate`
3. Install dependencies from requirements.txt: `pip3 install -r requirements.txt`
4. Run python script to confirm successful: `python3 run_elk_ci.py -h`
5. Setup script to run on schedule daily to ingest events and send to collective insights:
   - Example cron schedule to run at minute 0 every hour: `0 * * * * <FILE_DIR>/venv/bin/python3 <FILE_DIR>/run_elk_ci.py -k RF_API_KEY`

# **Troubleshooting**

The below section is for providing assistance with troubleshooting when having issues running the script.

- Script is failing due to modules not installed.
  - Confirm the requirements.txt was installed properly with pip3
  - Confirm the virtual environment where the python packages are installed is activated
- Not authorized to submit to Recorded Future Collective Insights API
  - Confirm that the Recorded Future API token has the correct Collective Insights API permissions activated
- Why am I ingesting more alerts from Elasticsearch than are being submitted to Collective Insights?
  - Collective Insights has filtering for unique indicators when submitting via the api

# **Changelog**

### 1.1.0 (2025-02-25)
* Add `es_alerts_index` for users to query a specific alerts index.
* Fix bug when parsing indicator type from alerts index with no assigned type.

### 1.0.0 (2024-10-11)
* Initial Release.
